package gov.va.med.mhv.getcare.converter;

import gov.va.med.mhv.getcare.common.dto.HealthInsuranceDTO;
import gov.va.med.mhv.getcare.model.HealthInsurance;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;

@Component
public class HealthInsuranceConverter  {

	public static HealthInsuranceDTO convertHealthInsuranceDomain(HealthInsurance e) {
		HealthInsuranceDTO dto = new HealthInsuranceDTO();
		dto.setUserProfileId(e.getUserProfileId());
		dto.setCompanyName(e.getCompanyName());
		dto.setCompanyPhone(e.getCompanyPhone());
		dto.setFirstNameOfInsured(e.getFirstNameOfInsured());
		dto.setLastNameOfInsured(e.getLastNameOfInsured());
		dto.setGroupNumber(e.getGroupNumber());
		dto.setPreApprovalPhone(e.getPreApprovalPhone());
		if(e.getPrimaryInd() == 1){
			dto.setPrimaryInd(true);
		}else{
			dto.setPrimaryInd(false);
		}
		dto.setStartDate(e.getStartDate());
		dto.setStopDate(e.getStopDate());
		dto.setComments(e.getComments());
		dto.setInsuranceIdNumber(e.getInsuranceIdNumber());
		dto.setHealthInsuranceId(e.getHealthInsuranceId());
		dto.setInsuranceIdNumber(e.getInsuranceIdNumber());
		return dto;
	}

	
	public static HealthInsurance convertHealthInsuranceDTO(HealthInsuranceDTO dto) {
		HealthInsurance e = new HealthInsurance();
		e.setUserProfileId(dto.getUserProfileId());
		e.setCompanyName(dto.getCompanyName());
		e.setCompanyPhone(dto.getCompanyPhone());
		e.setFirstNameOfInsured(dto.getFirstNameOfInsured());
		e.setLastNameOfInsured(dto.getLastNameOfInsured());
		e.setGroupNumber(dto.getGroupNumber());
		e.setOplock(0);
		e.setPreApprovalPhone(dto.getPreApprovalPhone());
		if(dto.getPrimaryInd()){
			e.setPrimaryInd(1);
		}else{
			e.setPrimaryInd(0);
		}
		e.setStartDate(dto.getStartDate());
		e.setStopDate(dto.getStopDate());
		e.setComments(dto.getComments());
		e.setInsuranceIdNumber(dto.getInsuranceIdNumber());
		e.setHealthInsuranceId(dto.getHealthInsuranceId());
		e.setInsuranceIdNumber(dto.getInsuranceIdNumber());
		return e;
	}
	
	public static List<HealthInsuranceDTO>  convertHealthInsurances( List<HealthInsurance> insurances ){
		List<HealthInsuranceDTO> dtos = new ArrayList<HealthInsuranceDTO>();
		for(HealthInsurance insurance : insurances){
			HealthInsuranceDTO dto = convertHealthInsuranceDomain(insurance);
			dtos.add(dto);
		}
		return dtos;
	}
}
